/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.merge;

import ancestris.modules.releve.merge.MergeTableAction;
import ancestris.modules.releve.merge.ProposalHelper;
import ancestris.modules.releve.merge.ProposalRule;
import ancestris.modules.releve.merge.ProposalRuleTableModel;
import genj.gedcom.Entity;
import genj.gedcom.Property;
import genj.gedcom.PropertyAssociation;
import genj.gedcom.PropertyChoiceRole;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyMedia;
import genj.gedcom.PropertyMultilineValue;
import genj.gedcom.PropertyPlace;
import genj.gedcom.PropertyQuality;
import genj.gedcom.PropertySource;
import genj.gedcom.values.EnumOperations;
import genj.gedcom.values.RoleEnum;
import genj.util.WordBuffer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class MergeTable
extends JTable {
    private static final Color BLUECOLOR = new Color(200, 255, 255);
    private static final Color GREYCOLOR = new Color(240, 240, 240);
    private static final String[] ROLES = EnumOperations.getDisplayChoices((Enum[])RoleEnum.values());
    private ButtonCell sourceCell;
    private final ComboChoices comboReliability;
    private final ComboSmall comboSourceCitation;
    private final ComboSmall comboText;
    private final ComboSmall comboMedia;
    protected static final String EDIT_CELL = "editCell";
    private final MergeTableCellEditor tableCellEditor;
    private final Map<MergeTableAction.WitnessRecordSelection, ButtonCell> mapWitnessCells = new HashMap<MergeTableAction.WitnessRecordSelection, ButtonCell>();
    private final Map<MergeTableAction.WitnessAssociationSelection, ComboSmall> mapWitnessCombos = new HashMap<MergeTableAction.WitnessAssociationSelection, ComboSmall>();
    private final Map<MergeTableAction.WitnessRoleRecordSelection, ComboChoices> mapWitnessRoleCombos = new HashMap<MergeTableAction.WitnessRoleRecordSelection, ComboChoices>();

    public MergeTable() {
        this.setPreferredSize(null);
        this.setAutoResizeMode(2);
        this.setBackground(new Color(UIManager.getColor("Table.background").getRGB()));
        this.setForeground(new Color(UIManager.getColor("Table.foreground").getRGB()));
        this.setSelectionBackground(new Color(UIManager.getColor("Table.background").getRGB()));
        this.setShowGrid(true);
        this.getTableHeader().setReorderingAllowed(false);
        MergeTableCellRenderer mergeTableRenderer = new MergeTableCellRenderer();
        this.setDefaultRenderer(Object.class, mergeTableRenderer);
        this.tableCellEditor = new MergeTableCellEditor();
        this.setDefaultEditor(Object.class, this.tableCellEditor);
        this.comboReliability = new ComboChoices(PropertyQuality.QUALITIES, this.tableCellEditor);
        this.comboSourceCitation = new ComboSmall(this.tableCellEditor);
        this.comboText = new ComboSmall(this.tableCellEditor);
        this.comboMedia = new ComboSmall(this.tableCellEditor);
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JTable target = (JTable)e.getSource();
                int column = target.columnAtPoint(e.getPoint());
                if (column == 1 || column == 3 || column == 4) {
                    int row = target.rowAtPoint(e.getPoint());
                    Object value = MergeTable.this.getModel().getValueAt(row, column);
                    if (value instanceof MergeTableAction) {
                        MergeTable.this.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        MergeTable.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        });
    }

    public void setModel(ProposalRuleTableModel model) {
        super.setModel(model);
        this.loadColumnLayout();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        if (column == 2) {
            ProposalRule.CompareResult cr = ((ProposalRuleTableModel)this.getModel()).getCompareResult(row);
            if (cr == ProposalRule.CompareResult.NOT_APPLICABLE || cr == ProposalRule.CompareResult.MANDATORY || cr == ProposalRule.CompareResult.EQUAL) {
                JLabel label = new JLabel("");
                if (cr == ProposalRule.CompareResult.EQUAL) {
                    label.setHorizontalAlignment(0);
                    label.setText("=");
                }
                return label;
            }
            return super.prepareRenderer(renderer, row, column);
        }
        return super.prepareRenderer(renderer, row, column);
    }

    protected void componentClosed() {
        this.saveColumnLayout();
    }

    private void loadColumnLayout() {
        String columnLayout = NbPreferences.forModule(MergeTable.class).get("MergeColumnLayout", "5,75,150,23,156,104");
        try {
            StringTokenizer tokens = new StringTokenizer(columnLayout, ",");
            int n = Integer.parseInt(tokens.nextToken());
            TableColumnModel columns = this.getColumnModel();
            for (int i = 0; i < n && i < columns.getColumnCount(); ++i) {
                TableColumn col = columns.getColumn(i);
                int w = Integer.parseInt(tokens.nextToken());
                col.setWidth(w);
                col.setPreferredWidth(w);
                col.setMinWidth(20);
            }
            String maxtext0 = "AAAAAAAAAA";
            String maxtext4 = "AAAAAAAAAAAAAAAAAAAA";
            for (int i = 0; i < this.getRowCount(); ++i) {
                String text;
                if (this.getModel().getValueAt(i, 4) != null && (text = this.getModel().getValueAt(i, 0).toString()).length() > maxtext0.length()) {
                    maxtext0 = text;
                }
                if (this.getModel().getValueAt(i, 4) == null || (text = this.getModel().getValueAt(i, 4).toString()).length() <= maxtext4.length()) continue;
                maxtext4 = text;
            }
            columns.getColumn(0).setMaxWidth(this.getGraphics().getFontMetrics().stringWidth(maxtext0) * 2 + 15);
            columns.getColumn(4).setMaxWidth(this.getGraphics().getFontMetrics().stringWidth(maxtext0) * 2 + 15);
            columns.getColumn(2).setMinWidth(25);
            columns.getColumn(2).setMaxWidth(25);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void saveColumnLayout() {
        TableColumnModel columns = this.getColumnModel();
        WordBuffer columnLayout = new WordBuffer(",");
        columnLayout.append(columns.getColumnCount());
        for (int c = 0; c < columns.getColumnCount(); ++c) {
            columnLayout.append(columns.getColumn(c).getWidth());
        }
        NbPreferences.forModule(MergeTable.class).put("MergeColumnLayout", columnLayout.toString());
    }

    public static String wrapToolTip(String tip, int maxLength) {
        int MARGING = 20;
        int position = 0;
        StringBuilder sb = new StringBuilder("<html>");
        while (position < tip.length()) {
            String buffer = position + maxLength + 20 > tip.length() ? tip.substring(position) : tip.substring(position, position + maxLength + 20);
            int firstReturn = buffer.indexOf(10);
            if (firstReturn != -1) {
                sb.append(tip.substring(position, position + firstReturn)).append("<br>");
                position = position + firstReturn + 1;
                continue;
            }
            if (buffer.length() > maxLength) {
                int lastSpace = buffer.lastIndexOf(32);
                if (lastSpace != -1) {
                    sb.append(tip.substring(position, position + lastSpace)).append("<br>");
                    position = position + lastSpace + 1;
                    continue;
                }
                int separator = buffer.lastIndexOf(44);
                if (separator != -1) {
                    sb.append(tip.substring(position, position + separator + 1)).append("<br>");
                    position = position + separator + 1;
                    continue;
                }
                sb.append(tip.substring(position, position + maxLength + 1)).append("<br>");
                position += maxLength;
                continue;
            }
            sb.append(tip.substring(position));
            break;
        }
        sb.append("</html>");
        return sb.toString();
    }

    class MergeTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public MergeTableCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (!(table.getModel() instanceof ProposalRuleTableModel)) {
                return this;
            }
            JComponent component = this;
            ProposalRuleTableModel model = (ProposalRuleTableModel)table.getModel();
            this.setFont(table.getFont());
            this.setToolTipText(null);
            this.setBorder(new EmptyBorder(0, 2, 0, 4));
            int modelColumn = col;
            if (value != null) {
                if (value instanceof PropertyDate) {
                    PropertyDate propertyDate = (PropertyDate)value;
                    this.setText(propertyDate.getDisplayValue());
                    if (propertyDate.getPhrase() != null && !propertyDate.getPhrase().isEmpty()) {
                        this.setToolTipText(MergeTable.wrapToolTip(propertyDate.getPhrase(), 80));
                    }
                } else if (value instanceof PropertyPlace) {
                    PropertyPlace propertyPlace = (PropertyPlace)value;
                    this.setText(propertyPlace.getDisplayValue());
                } else if (value instanceof PropertyQuality) {
                    PropertyQuality propertyReliability = (PropertyQuality)value;
                    this.setText(PropertyQuality.QUALITIES[propertyReliability.getQuality()]);
                } else {
                    if (value instanceof MergeTableAction.SourceRecordSelection) {
                        MergeTableAction.SourceRecordSelection sourceAction = (MergeTableAction.SourceRecordSelection)value;
                        if (MergeTable.this.sourceCell == null) {
                            MergeTable.this.sourceCell = new ButtonCell(sourceAction.getText(), MergeTable.this.tableCellEditor);
                        }
                        MergeTable.this.sourceCell.setText(sourceAction.getText());
                        MergeTable.this.sourceCell.setToolTipText(MergeTable.wrapToolTip(sourceAction.getToolTipText(), 60));
                        return MergeTable.this.sourceCell;
                    }
                    if (value instanceof MergeTableAction.SourceReliabilitySelection) {
                        MergeTableAction.SourceReliabilitySelection reliabilityAction = (MergeTableAction.SourceReliabilitySelection)value;
                        MergeTable.this.comboReliability.setSelectedIndex(reliabilityAction.getProperty().getQuality());
                        MergeTable.this.comboReliability.setToolTipText(MergeTable.wrapToolTip(reliabilityAction.getToolTipText(), 60));
                        component = MergeTable.this.comboReliability;
                    } else if (value instanceof MergeTableAction.SourceCitationSelection) {
                        MergeTableAction.SourceCitationSelection sourceCitationAction = (MergeTableAction.SourceCitationSelection)value;
                        MergeTable.this.comboSourceCitation.setModel(new DefaultComboBoxModel(sourceCitationAction.m_existingSourceCitations.toArray(PropertySource[]::new)));
                        MergeTable.this.comboSourceCitation.addItem("");
                        MergeTable.this.comboSourceCitation.setSelectedItem(sourceCitationAction.m_selectedProperty);
                        MergeTable.this.comboSourceCitation.setToolTipText(MergeTable.wrapToolTip(sourceCitationAction.getToolTipText(), 60));
                        component = MergeTable.this.comboSourceCitation;
                    } else if (value instanceof MergeTableAction.SourceTextSelection) {
                        MergeTableAction.SourceTextSelection sourceTextAction = (MergeTableAction.SourceTextSelection)value;
                        MergeTable.this.comboText.setModel(new DefaultComboBoxModel(sourceTextAction.m_existingSourceText.toArray(Property[]::new)));
                        MergeTable.this.comboText.addItem("");
                        MergeTable.this.comboText.setSelectedItem(sourceTextAction.m_selectedProperty);
                        MergeTable.this.comboText.setToolTipText(MergeTable.wrapToolTip(sourceTextAction.getToolTipText(), 60));
                        component = MergeTable.this.comboText;
                    } else if (value instanceof MergeTableAction.SourceMediaSelection) {
                        MergeTableAction.SourceMediaSelection sourceMediaAction = (MergeTableAction.SourceMediaSelection)value;
                        MergeTable.this.comboMedia.setModel(new DefaultComboBoxModel(sourceMediaAction.m_existingSourceMedias.toArray(Property[]::new)));
                        ListMediaCellRenderer renderer = new ListMediaCellRenderer(MergeTable.this.comboMedia.getRenderer());
                        MergeTable.this.comboMedia.setRenderer(renderer);
                        MergeTable.this.comboMedia.addItem("");
                        MergeTable.this.comboMedia.setSelectedItem(sourceMediaAction.m_selectedMedia);
                        MergeTable.this.comboMedia.setToolTipText(MergeTable.wrapToolTip(sourceMediaAction.getToolTipText(), 60));
                        component = MergeTable.this.comboMedia;
                    } else {
                        if (value instanceof MergeTableAction.WitnessRecordSelection) {
                            MergeTableAction.WitnessRecordSelection witnessRecordselection = (MergeTableAction.WitnessRecordSelection)value;
                            ButtonCell witnessCell = MergeTable.this.mapWitnessCells.get(witnessRecordselection);
                            if (witnessCell == null) {
                                witnessCell = new ButtonCell(witnessRecordselection.getText(), MergeTable.this.tableCellEditor);
                                MergeTable.this.mapWitnessCells.put(witnessRecordselection, witnessCell);
                            }
                            witnessCell.setText(witnessRecordselection.getText());
                            witnessCell.setToolTipText(MergeTable.wrapToolTip(witnessRecordselection.getToolTipText(), 60));
                            return witnessCell;
                        }
                        if (value instanceof MergeTableAction.WitnessAssociationSelection) {
                            MergeTableAction.WitnessAssociationSelection witnessAssociationSelection = (MergeTableAction.WitnessAssociationSelection)value;
                            ComboSmall comboAsso = MergeTable.this.mapWitnessCombos.get(witnessAssociationSelection);
                            if (comboAsso == null) {
                                comboAsso = new ComboSmall(MergeTable.this.tableCellEditor);
                                MergeTable.this.mapWitnessCombos.put(witnessAssociationSelection, comboAsso);
                            }
                            comboAsso.setModel(new DefaultComboBoxModel(witnessAssociationSelection.m_existingAssociations.toArray(Property[]::new)));
                            ListAssoCellRenderer renderer = new ListAssoCellRenderer(comboAsso.getRenderer());
                            comboAsso.setRenderer(renderer);
                            comboAsso.addItem("");
                            comboAsso.setSelectedItem(witnessAssociationSelection.m_selectedAssociation);
                            comboAsso.setToolTipText(MergeTable.wrapToolTip(witnessAssociationSelection.getToolTipText(), 60));
                            component = comboAsso;
                        } else if (value instanceof MergeTableAction.WitnessRoleRecordSelection) {
                            MergeTableAction.WitnessRoleRecordSelection witnessRoleRecordselection = (MergeTableAction.WitnessRoleRecordSelection)value;
                            ComboChoices comboRole = MergeTable.this.mapWitnessRoleCombos.get(witnessRoleRecordselection);
                            if (comboRole == null) {
                                comboRole = new ComboChoices(ROLES, MergeTable.this.tableCellEditor);
                                MergeTable.this.mapWitnessRoleCombos.put(witnessRoleRecordselection, comboRole);
                            }
                            comboRole.setSelectedItem(witnessRoleRecordselection.getProperty().getDisplayValue());
                            comboRole.setToolTipText(MergeTable.wrapToolTip(witnessRoleRecordselection.getToolTipText(), 60));
                            component = comboRole;
                        } else if (value instanceof PropertyChoiceRole) {
                            PropertyChoiceRole role = (PropertyChoiceRole)value;
                            this.setText(role.getDisplayValue());
                        } else if (value instanceof MergeTableAction.ShowEntityAction) {
                            MergeTableAction.ShowEntityAction entityAction = (MergeTableAction.ShowEntityAction)value;
                            this.setText(entityAction.getText());
                            this.setToolTipText(MergeTable.wrapToolTip(entityAction.getToolTipText(), 50));
                        } else {
                            String comment = value instanceof Property ? ((Property)value).getValue() : value.toString();
                            this.setText(comment.replace('\n', ' '));
                            if (!(comment.length() <= 8 || col != 1 && col != 3 || value.toString().isEmpty())) {
                                this.setToolTipText(MergeTable.wrapToolTip(comment, 80));
                            }
                        }
                    }
                }
            } else {
                this.setText("");
            }
            block0 : switch (modelColumn) {
                case 3: {
                    ((Component)component).setForeground(table.getForeground());
                    switch (model.getCompareResult(row)) {
                        case EQUAL: 
                        case MANDATORY: 
                        case NOT_APPLICABLE: {
                            ((Component)component).setBackground(table.getBackground());
                            break block0;
                        }
                        case CONFLICT: {
                            ((Component)component).setBackground(Color.PINK);
                            break block0;
                        }
                    }
                    if (!model.isMergeChanged(row)) {
                        ((Component)component).setBackground(BLUECOLOR);
                        break;
                    }
                    if (model.getMerge(row)) {
                        ((Component)component).setBackground(BLUECOLOR);
                        break;
                    }
                    ((Component)component).setBackground(GREYCOLOR);
                    break;
                }
                case 4: {
                    if (value instanceof MergeTableAction.ShowEntityAction) {
                        if (value instanceof MergeTableAction.ShowEntityAction) {
                            MergeTableAction.ShowEntityAction entityAction = (MergeTableAction.ShowEntityAction)value;
                            if (entityAction.m_entity != null) {
                                this.setForeground(Color.blue);
                            } else {
                                this.setForeground(table.getForeground());
                            }
                        }
                    } else {
                        this.setForeground(table.getForeground());
                    }
                    this.setBackground(table.getBackground());
                    break;
                }
                default: {
                    this.setBackground(table.getBackground());
                    this.setForeground(table.getForeground());
                }
            }
            return component;
        }
    }

    class MergeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener,
    ItemListener {
        private final JLabel label = new JLabel();
        private Object currentValue;

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            if (value instanceof MergeTableAction.SourceReliabilitySelection) {
                MergeTableAction.SourceReliabilitySelection reliabilityAction = (MergeTableAction.SourceReliabilitySelection)value;
                this.currentValue = value;
                MergeTable.this.comboReliability.setSelectedIndex(reliabilityAction.getProperty().getQuality());
                return MergeTable.this.comboReliability;
            }
            if (value instanceof MergeTableAction.SourceCitationSelection) {
                MergeTableAction.SourceCitationSelection sourceCitationAction = (MergeTableAction.SourceCitationSelection)value;
                this.currentValue = value;
                MergeTable.this.comboSourceCitation.setSelectedItem(sourceCitationAction.getProperty());
                return MergeTable.this.comboSourceCitation;
            }
            if (value instanceof MergeTableAction.SourceTextSelection) {
                MergeTableAction.SourceTextSelection sourceTextAction = (MergeTableAction.SourceTextSelection)value;
                this.currentValue = value;
                MergeTable.this.comboText.setSelectedItem(sourceTextAction.getProperty());
                return MergeTable.this.comboText;
            }
            if (value instanceof MergeTableAction.SourceMediaSelection) {
                MergeTableAction.SourceMediaSelection sourceMediaAction = (MergeTableAction.SourceMediaSelection)value;
                this.currentValue = value;
                MergeTable.this.comboMedia.setSelectedItem(sourceMediaAction.getProperty());
                return MergeTable.this.comboMedia;
            }
            if (value instanceof MergeTableAction.SourceRecordSelection) {
                MergeTableAction.SourceRecordSelection sourceAction = (MergeTableAction.SourceRecordSelection)value;
                this.currentValue = value;
                MergeTable.this.sourceCell.setText(sourceAction.getText());
                return MergeTable.this.sourceCell;
            }
            if (value instanceof MergeTableAction.WitnessRecordSelection) {
                MergeTableAction.WitnessRecordSelection witnessAction = (MergeTableAction.WitnessRecordSelection)value;
                this.currentValue = value;
                ButtonCell witnessCell = MergeTable.this.mapWitnessCells.get(witnessAction);
                witnessCell.setText(witnessAction.getText());
                return witnessCell;
            }
            if (value instanceof MergeTableAction.WitnessAssociationSelection) {
                MergeTableAction.WitnessAssociationSelection witnessAssociationAction = (MergeTableAction.WitnessAssociationSelection)value;
                this.currentValue = value;
                ComboSmall comboAsso = MergeTable.this.mapWitnessCombos.get(witnessAssociationAction);
                comboAsso.setSelectedItem(witnessAssociationAction.getProperty());
                return comboAsso;
            }
            if (value instanceof MergeTableAction.WitnessRoleRecordSelection) {
                MergeTableAction.WitnessRoleRecordSelection witnessRoleAction = (MergeTableAction.WitnessRoleRecordSelection)value;
                this.currentValue = value;
                ComboChoices comboRole = MergeTable.this.mapWitnessRoleCombos.get(witnessRoleAction);
                if (comboRole != null) {
                    comboRole.setSelectedItem(witnessRoleAction.getText());
                    return comboRole;
                }
                this.label.setText("");
                return this.label;
            }
            if (value instanceof MergeTableAction.ShowEntityAction) {
                MergeTableAction.ShowEntityAction entityAction = (MergeTableAction.ShowEntityAction)value;
                entityAction.showAction(null, true);
                this.currentValue = entityAction.getText();
                this.label.setText(entityAction.getText());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MergeTableCellEditor.this.fireEditingCanceled();
                    }
                });
                return this.label;
            }
            return this.label;
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getStateChange() == 1) {
                Object object = this.currentValue;
                if (object instanceof MergeTableAction.SourceReliabilitySelection) {
                    MergeTableAction.SourceReliabilitySelection action = (MergeTableAction.SourceReliabilitySelection)object;
                    action.getProperty().setQuality(MergeTable.this.comboReliability.getSelectedIndex());
                    this.fireEditingStopped();
                } else {
                    object = this.currentValue;
                    if (object instanceof MergeTableAction.SourceCitationSelection) {
                        MergeTableAction.SourceCitationSelection action = (MergeTableAction.SourceCitationSelection)object;
                        action.m_selectedProperty = MergeTable.this.comboSourceCitation.getSelectedItem() instanceof String ? null : (PropertySource)MergeTable.this.comboSourceCitation.getSelectedItem();
                        this.fireEditingStopped();
                    } else {
                        object = this.currentValue;
                        if (object instanceof MergeTableAction.SourceTextSelection) {
                            MergeTableAction.SourceTextSelection action = (MergeTableAction.SourceTextSelection)object;
                            action.m_selectedProperty = MergeTable.this.comboText.getSelectedItem() instanceof String ? null : (PropertyMultilineValue)MergeTable.this.comboText.getSelectedItem();
                            this.fireEditingStopped();
                        } else {
                            object = this.currentValue;
                            if (object instanceof MergeTableAction.SourceMediaSelection) {
                                MergeTableAction.SourceMediaSelection action = (MergeTableAction.SourceMediaSelection)object;
                                action.m_selectedMedia = MergeTable.this.comboMedia.getSelectedItem() instanceof String ? null : (PropertyMedia)MergeTable.this.comboMedia.getSelectedItem();
                                this.fireEditingStopped();
                            } else {
                                object = this.currentValue;
                                if (object instanceof MergeTableAction.WitnessRoleRecordSelection) {
                                    MergeTableAction.WitnessRoleRecordSelection action = (MergeTableAction.WitnessRoleRecordSelection)object;
                                    comboRole = MergeTable.this.mapWitnessRoleCombos.get(action);
                                    if (comboRole != null) {
                                        action.getProperty().setValue(ROLES[((JComboBox)comboRole).getSelectedIndex()]);
                                    }
                                    this.fireEditingStopped();
                                } else {
                                    comboRole = this.currentValue;
                                    if (comboRole instanceof MergeTableAction.WitnessAssociationSelection) {
                                        MergeTableAction.WitnessAssociationSelection action = (MergeTableAction.WitnessAssociationSelection)comboRole;
                                        ComboSmall comboAsso = MergeTable.this.mapWitnessCombos.get(action);
                                        action.m_selectedAssociation = comboAsso != null && comboAsso.getSelectedItem() instanceof PropertyAssociation ? (PropertyAssociation)comboAsso.getSelectedItem() : null;
                                        this.fireEditingStopped();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (MergeTable.EDIT_CELL.equals(evt.getActionCommand())) {
                MergeTableAction action;
                Object object = this.currentValue;
                if (object instanceof MergeTableAction.SourceRecordSelection) {
                    action = (MergeTableAction.SourceRecordSelection)object;
                    ((MergeTableAction.SourceRecordSelection)action).editAction(null);
                }
                if ((object = this.currentValue) instanceof MergeTableAction.WitnessRecordSelection) {
                    action = (MergeTableAction.WitnessRecordSelection)object;
                    ((MergeTableAction.WitnessRecordSelection)action).editAction(null);
                }
                this.fireEditingStopped();
            }
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentValue;
        }
    }

    static class ComboChoices
    extends JComboBox<Object> {
        public ComboChoices(String[] model, MergeTableCellEditor editor) {
            super(model);
            this.setBorder(new EmptyBorder(0, 2, 0, 4));
            this.setUI(new MergeComboBoxUI(this));
            this.addItemListener(editor);
        }
    }

    static class ComboSmall
    extends JComboBox<Object> {
        public ComboSmall(MergeTableCellEditor editor) {
            this.setBorder(new EmptyBorder(0, 2, 0, 4));
            this.setUI(new MergeComboBoxUI(this));
            this.addItemListener(editor);
        }
    }

    private static class ListAssoCellRenderer
    implements ListCellRenderer<Object> {
        private final ListCellRenderer<? super Object> renderer;

        public ListAssoCellRenderer(ListCellRenderer<? super Object> renderer) {
            this.renderer = renderer;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = "";
            if (value instanceof PropertyAssociation) {
                PropertyAssociation pAsso = (PropertyAssociation)value;
                Entity entity = pAsso.getWitness();
                text = entity.toString(false);
            } else if (value instanceof String) {
                String str;
                text = str = (String)value;
            }
            return this.renderer.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
        }
    }

    private static class ListMediaCellRenderer
    implements ListCellRenderer<Object> {
        private final ListCellRenderer<? super Object> renderer;
        private final String noFileLabel;

        public ListMediaCellRenderer(ListCellRenderer<? super Object> renderer) {
            this.renderer = renderer;
            this.noFileLabel = NbBundle.getMessage(MergeTable.class, (String)"error.msg.NoFileMedia");
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = "";
            if (value instanceof PropertyMedia) {
                PropertyMedia pMedia = (PropertyMedia)value;
                text = ProposalHelper.getFileValue(pMedia);
                if (text.isEmpty()) {
                    text = this.noFileLabel;
                }
            } else if (value instanceof String) {
                String str;
                text = str = (String)value;
            }
            return this.renderer.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
        }
    }

    static class MergeComboBoxUI
    extends BasicComboBoxUI {
        private JComboBox<Object> m_comboBox;

        MergeComboBoxUI(JComboBox<Object> comboBox) {
            this.m_comboBox = comboBox;
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            this.m_comboBox.setBackground(new Color(UIManager.getColor("Table.background").getRGB()));
            this.m_comboBox.setForeground(new Color(UIManager.getColor("Table.foreground").getRGB()));
            this.m_comboBox.setFont(new Font("Dialog", 0, 12));
        }

        @Override
        public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
            Component c;
            ListCellRenderer<Object> renderer = this.m_comboBox.getRenderer();
            if (hasFocus && !this.isPopupVisible(this.m_comboBox)) {
                c = renderer.getListCellRendererComponent(this.listBox, this.m_comboBox.getSelectedItem(), -1, true, false);
            } else {
                c = renderer.getListCellRendererComponent(this.listBox, this.m_comboBox.getSelectedItem(), -1, false, false);
                c.setBackground(this.m_comboBox.getForeground());
                c.setBackground(this.m_comboBox.getBackground());
            }
            c.setFont(this.m_comboBox.getFont());
            if (hasFocus && !this.isPopupVisible(this.m_comboBox)) {
                c.setForeground(this.m_comboBox.getForeground());
                c.setBackground(this.m_comboBox.getBackground());
            } else if (this.m_comboBox.isEnabled()) {
                c.setForeground(this.m_comboBox.getForeground());
                c.setBackground(this.m_comboBox.getBackground());
            } else {
                c.setForeground(this.m_comboBox.getForeground());
                c.setBackground(this.m_comboBox.getBackground());
            }
            boolean shouldValidate = false;
            if (c instanceof JPanel) {
                shouldValidate = true;
            }
            int x = bounds.x;
            int y = bounds.y;
            int w = bounds.width;
            int h = bounds.height;
            this.currentValuePane.paintComponent(g, c, this.m_comboBox, x, y, w, h, shouldValidate);
        }

        @Override
        protected JButton createArrowButton() {
            JButton b = new JButton(new ArrowIcon());
            b.setBackground(Color.BLACK);
            b.setContentAreaFilled(false);
            b.setFocusPainted(false);
            b.setBorder(BorderFactory.createEmptyBorder());
            return b;
        }
    }

    static class ArrowIcon
    implements Icon {
        ArrowIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setPaint(Color.BLACK);
            int shift = 0;
            if (c instanceof AbstractButton && ((AbstractButton)c).getModel().isPressed()) {
                shift = 1;
            }
            g2.translate(x, y + shift);
            g2.drawLine(1, 2, 9, 2);
            g2.drawLine(2, 3, 8, 3);
            g2.drawLine(3, 4, 7, 4);
            g2.drawLine(4, 5, 6, 5);
            g2.drawLine(5, 6, 5, 6);
            g2.dispose();
        }

        @Override
        public int getIconWidth() {
            return 11;
        }

        @Override
        public int getIconHeight() {
            return 11;
        }
    }

    static class ButtonCell
    extends JPanel {
        private JLabel label = new JLabel();
        protected JButton button = new JButton("...");

        ButtonCell(String textLabel, final MergeTableCellEditor editor) {
            this.setLayout(new BorderLayout());
            this.setBorder(null);
            this.add((Component)this.button, "East");
            this.add((Component)this.label, "Center");
            this.button.setPreferredSize(new Dimension(24, 24));
            this.label.setFont(new Font("Dialog", 0, 12));
            this.label.setBackground(new Color(UIManager.getColor("Table.background").getRGB()));
            this.setOpaque(false);
            this.label.setText(textLabel);
            this.setBorder(new EmptyBorder(0, 2, 0, 4));
            this.button.setActionCommand(MergeTable.EDIT_CELL);
            this.button.addActionListener(editor);
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent me) {
                    editor.actionPerformed(new ActionEvent(button, 1001, MergeTable.EDIT_CELL));
                }
            });
        }

        public void setText(String value) {
            this.label.setText(value);
        }

        @Override
        public void setToolTipText(String value) {
            super.setToolTipText(value);
            this.button.setToolTipText(value);
        }
    }
}

